#!/bin/sh
# event number is passed as parameter 1
# suggested event numbers;
# 20	Backup
# 30	BundyScript (ie keypad or scheduled)
# 40 	Firmware Update (45 update successful)
# 60	Manual (not used on the clock)
# 100	Rebooting
# 120	Shutting Down
# 140 Setup (from the clock setup script, typically run by production team)
# 150 Started (152 Clock start is succesful)
#

# Check for a network connection. Set NETUP accordingly.
check_network() {
NETUP=1
# Check if a default route exists
IFDEF=$(ip route |  grep '^\<default\>' | wc -l)
if [ $IFDEF -eq 0 ]
then
	NETUP=0
	return
fi
# if default route is on eth., then check that iface is not DOWN
ETHDEF=$(ip route |  grep '^\<default\>.*\<eth.\>[ ]*$' | wc -l)
if [ $ETHDEF -eq 1 ]
then
	IFACE=$(ip route |  grep '^\<default\>.*\<eth.\>[ ]*$' | sed 's/.* \(\<eth.\>\)/\1/')
	ETHDOWN=$(ip address show $IFACE | grep '\<state\>[ /t]*\<DOWN\>' | wc -l)
	if [ $ETHDOWN -eq 1 ]
	then
		NETUP=0
	fi
fi
} #check_network

# Check that there is a network connection before collecting data and sending
check_network

if [ $NETUP -eq 1 ]
then

	#limitations on curl
	CURL_MAX=150
	CURL_CON=25
	#CURL_RETRY=2

	if [ $# == 3 ]
	then
		mkdir /var/tmp/$3
		PATH="/var/tmp/$3"
	else
		PATH="/var/tmp"
	fi

	# API_SITE=http://api.cstimeclocks.com/ping
	API_SITE=http://api.cstimeclocks.com/ping
	CLOCK_BUILD_NUMBER=3015
	CLOCK_VERSION=3.01e
	HOSTNAME=$(/bin/hostname)
	SERIAL=$(/bin/cat /var/local/data/SerialNumber.txt)
	UPDATETYPE=$(/bin/cat /var/local/data/update_type)
	DATE=$(/bin/date)
	BACKUP_FILE="/var/local/data/Backup.txt"
	BACKUP_SITE=$(/bin/cat $BACKUP_FILE)
	DMESG=$PATH/dmsg.txt
	MOUNT=$PATH/mount.txt
	NETSTAT=$PATH/netstat.txt
	PS=$PATH/ps.txt
	LS=$PATH/ls.txt
	DF=$PATH/df.txt
	TOP=$PATH/top.txt
	IFCONFIG=$PATH/ifconfig.txt
	FDISK=$PATH/fdisk.txt
	SSID=$PATH/wpa_supplicant.txt
	ROUTE=$PATH/route.txt
	SDSERIAL=$(/bin/cat /sys/block/mmcblk0/device/serial)

	# gather various current states
	/bin/dmesg | /usr/bin/tail -n 200 > $DMESG
	/bin/mount > $MOUNT
	/bin/ps aux > $PS
	/bin/ls -l /var/local/data > $LS
	/bin/df > $DF
	/usr/bin/top -n 1 -b > $TOP
	/sbin/ifconfig -a > $IFCONFIG
	/sbin/fdisk -l > $FDISK
	/bin/netstat > $NETSTAT
	/bin/cat /etc/wpa_supplicant.conf > $SSID
	/sbin/ip route > $ROUTE
	/bin/gzip -f $DMESG
	/bin/gzip -f $MOUNT
	/bin/gzip -f $PS
	/bin/gzip -f $LS
	/bin/gzip -f $DF
	/bin/gzip -f $TOP
	/bin/gzip -f $IFCONFIG
	/bin/gzip -f $FDISK
	/bin/gzip -f $NETSTAT
	/bin/gzip -f $SSID
	/bin/gzip -f $ROUTE

	# send to monitoring server
	/usr/bin/curl --connect-timeout $CURL_CON --max-time $CURL_MAX -F serial=$SERIAL -F eventid=$1 -F desc=$2 -F hostname=$HOSTNAME -F updatetype=$UPDATETYPE -F version=$CLOCK_VERSION -F date="$DATE" -F backupsite=$BACKUP_SITE -F dmesg=@$DMESG.gz -F mount=@$MOUNT.gz -F ls=@$LS.gz -F ps=@$PS.gz -F df=@$DF.gz -F top=@$TOP.gz -F fdisk=@$FDISK.gz -F ifconfig=@$IFCONFIG.gz -F netstat=@$NETSTAT.gz -F wpasupplicant=@$SSID.gz -F route=@$ROUTE.gz -F sdserial=$SDSERIAL $API_SITE
fi
