#!/bin/sh

# -----------------------------------------------------
# this script populates the database with the current ip settings
# -----------------------------------------------------

DATABASE=/var/local/data/capeclock.db
SQLITE3SHELL=/usr/local/bin/sqlite3shell

DHCP=`sed '/^iface eth0 inet */!d; s///;q' /etc/network/interfaces`
IP=`sed '/^[ ]*address */!d; s///;q' /etc/network/interfaces`
NM=`sed '/^[ ]*netmask */!d; s///;q' /etc/network/interfaces`
BC=`sed '/^[ ]*broadcast */!d; s///;q' /etc/network/interfaces`
GW=`sed '/^[ ]*gateway */!d; s///;q' /etc/network/interfaces`

DNS1=`sed '/^nameserver/!d' /etc/resolv.conf | sed -n '1 p' | sed ' s/^nameserver //;q'`
DNS2=`sed '/^nameserver/!d' /etc/resolv.conf | sed -n '2 p' | sed ' s/^nameserver //;q'`
DNS3=`sed '/^nameserver/!d' /etc/resolv.conf | sed -n '3 p' | sed ' s/^nameserver //;q'`
DNS4=`sed '/^nameserver/!d' /etc/resolv.conf | sed -n '4 p' | sed ' s/^nameserver //;q'`

if [ $DHCP = 'dhcp' ] ; then
	DHCP=1
else
	DHCP=0
fi

echo "DHCP = $DHCP"
echo "IP = $IP"
echo "NM = $NM"
echo "BC = $BC"
echo "GW = $GW"
echo "DNS1 = $DNS1"
echo "DNS2 = $DNS2"
echo "DNS3 = $DNS3"
echo "DNS4 = $DNS4"

SQLCOMMAND="update thisdev set dhcp='$DHCP', ip='$IP', netmask='$NM', broadcast='$BC', gateway='$GW', nameserver1='$DNS1', nameserver2='$DNS2', nameserver3='$DNS3', nameserver4='$DNS4' where setip = 0;"

echo "$SQLCOMMAND" | $SQLITE3SHELL $DATABASE 

#echo -e ".mode line\nselect * from thisdev;" | $SQLITE3SHELL $DATABASE 

# -----------------------------------------------------

