#! /bin/sh

set_mac_address() {
	# Set the MAC address
	HI=$((($1 & 0xFF00) >> 8))
	LO=$(($1 & 0xFF))
	HI=$(echo "obase=16; $HI" | bc)
	LO=$(echo "obase=16; $LO" | bc)
	MAC=00:04:25:12:$HI:$LO
	sed -i "s/^[ \t]*hwaddress[ \t]*ether[ \t]*[0-9a-fA-F:]*/\thwaddress ether $MAC/" /etc/network/interfaces
}

# look for CSTCxxxxx
ISERCNT=$(grep "#CSTC[0-9]*" /etc/network/interfaces | wc -l)
if [[ $ISERCNT -eq 1 ]]	# if found, replace
then
	# check if correct
	ISER=$(sed -n "/#CSTC[0-9]*/p" /etc/network/interfaces)
	if [ "$ISER" != "#CSTC$1" ]
	then
		sed -i "s/#CSTC[0-9]*/#CSTC$1/" /etc/network/interfaces
		set_mac_address $1
		exit 1
	else
		echo "Equal!"
	fi
elif [[ $ISERCNT -gt 1 ]]	# shouldn't be more than one line
then
	sed -i "/#CSTC[0-9]*/ d" /etc/network/interfaces
	echo "#CSTC$1" >> /etc/network/interfaces
	set_mac_address $1
	exit 1
else	# else write
	echo "#CSTC$1" >> /etc/network/interfaces
	set_mac_address $1
	exit 1
fi

exit 0


