#!/bin/sh

# -----------------------------------------------------
# this script sets up wlan from a usb stick
# -----------------------------------------------------

/usr/local/bin/mount_usb

INFILE=/mnt/1/cswifi.txt
TMPFILE=/tmp/cswifi.txt

if [ -e $INFILE ]
	then
	# Handle Windows and MAC line endings
	tr '\r' '\n' < $INFILE > $TMPFILE
	#ssid=ssidvalue
	SSID=$(cat $TMPFILE | sed '/^[ \t]*ssid=/!d; s/^[ \t]*ssid=//')
	#psk=passwordvalue
	PSK=$(cat $TMPFILE | sed '/^[ \t]*password=/!d; s/^[ \t]*password=//')
	# if ssid and psk are not 0 length
	if [ -n "$SSID" ]
		then
		if [ -n "$PSK" ]
			then
	 		# write to db
		 	/usr/local/bin/sqlite3shell /var/local/data/capeclock.db "update thisdev set wlanssid='$SSID', wlanpsk='$PSK' where id = 1;"
		 	# update /etc/wpa_supplicant.conf
			sed -i "2 s/=.*/=\"$SSID\"/" /etc/wpa_supplicant.conf
			sed -i "5 s/=.*/=\"$PSK\"/" /etc/wpa_supplicant.conf
		fi
	fi
fi

rm /etc/udev/rules.d/70-persistent-net.rules
rm $TMPFILE
# Fix network/interfaces file
INSERT=$(sed -n '/^iface wlan0 inet/{n;p}' /etc/network/interfaces | grep "wpa-conf" | wc -l)
if [[ $INSERT -gt 0 ]]
then
	sed -i 's|^[ \t]*wpa-conf /etc/wpa_supplicant.conf|  address 192.168.2.108\n  netmask 255.255.255.0\n  gateway 192.168.2.202\n  wpa-conf /etc/wpa_supplicant.conf|' /etc/network/interfaces
fi
umount /mnt/1

# -----------------------------------------------------
