-- -------------------------------------------------------------------------------------------------------------------------------------------------
-- -------------------------------------------------------------------------------------------------------------------------------------------------
-- CapeClock.db Alter Statements
-- Alter statements to keep existing clocks up to date
-- -------------------------------------------------------------------------------------------------------------------------------------------------
-- Notes:
-- 	remember all alter table add column text needs to be not null default ''
--
-- -------------------------------------------------------------------------------------------------------------------------------------------------

-- table readertype

delete from readertype;
insert into readertype (id,wieg,bitlen,char,desc) values (1, 1, 34, 0, 'KeyProx');
insert into readertype (id,wieg,bitlen,char,desc) values (2, 1, 34, 0, 'Proximity');
insert into readertype (id,wieg,bitlen,char,desc) values (3, 1, 10, 1, 'Keypad');

insert into readertype (id,wieg,bitlen,char,desc) values (261, 0, 0, 0, 'Bioscrypt Identify');
insert into readertype (id,wieg,bitlen,char,desc) values (262, 0, 0, 0, 'Bioscrypt Verify');
insert into readertype (id,wieg,bitlen,char,desc) values (265, 0, 0, 0, 'FS83 Identify');
insert into readertype (id,wieg,bitlen,char,desc) values (266, 0, 0, 0, 'FS83 Verify');


-- table area
alter table area add column pc integer default 2;

-- table route
alter table route add column pc integer default 2;

-- table chore
update chore set olddatatime = 120, checkolddatainterval = 60 where id = 1;	-- turns on this chore by default (may want to remove this from alter.sql in a few versions time)

-- table _info
alter table _info add column processorversion integer default 0;
alter table _info add column hostversion integer default 0;

-- table clocking
alter table clocking add column del integer default 0;
alter table clocking add column dt1 integer default 0;
alter table clocking add column dt2 text not null default '';
create unique index if not exists clocking_en_key on clocking(en,t,ty,stat);

-- table empproc
create table if not exists empproc (
	en text not null primary key,
	monstart integer,
	monend integer,
	monlunch integer,
	monexpected integer,
	tuestart integer,
	tueend integer,
	tuelunch integer,
	tueexpected integer,
	wedstart integer,
	wedend integer,
	wedlunch integer,
	wedexpected integer,
	thustart integer,
	thuend integer,
	thulunch integer,
	thuexpected integer,
	fristart integer,
	friend integer,
	frilunch integer,
	friexpected integer,
	satstart integer,
	satend integer,
	satlunch integer,
	satexpected integer,
	sunstart integer,
	sunend integer,
	sunlunch integer,
	sunexpected integer,
	pc integer default 2,
	runningtotals integer default -1,
	balancing integer default -1,
	autoendday integer default -1,
	leaveautoapproved integer default -1,
	rounding integer default -1	
);
alter table empproc add column balancing integer default -1;
alter table empproc add column runningtotals integer default -1;
alter table empproc add column autoendday integer default -1;
alter table empproc add column leaveautoapproved integer default -1;
alter table empproc add column rounding integer default -1;
alter table empproc add column pc integer default 2;

-- table hour
create table if not exists hour (
  id integer not null primary key,
  processed integer,
	en text not null,
	date integer,
	desc text not null default '', 
	hours1 integer,
	hours2 integer,
	hours3 integer,
	hours4 integer,
	hours5 integer,
	hours6 integer,
	hours7 integer,
	hours8 integer,
  hours9 integer,
	orhours1 integer default -1,
	orhours2 integer default -1,
	orhours3 integer default -1,
	orhours4 integer default -1,
	orhours5 integer default -1,
	orhours6 integer default -1,
	orhours7 integer default -1,
	orhours8 integer default -1,
	orhours9 integer default -1,
	lunch integer,
	orlunch integer default -1,
	suen text not null default '',
	stime integer,
	clockings text not null default '',
	awol integer default 0,
	expected text not null default '',
	comment text not null default '',
	runningtotal integer default 0,
	pc integer default 2,
	orrunningtotal integer default -1	
);
create index if not exists hour_namekey on hour(date,en);
create index if not exists hour_processkey on hour(processed,date);


alter table hour add column awol integer default 0;
alter table hour add column expected text not null default '';
alter table hour add column comment text not null default '';
alter table hour add column runningtotal integer default 0;
alter table hour add column suen text not null default '';
alter table hour add column pc integer default 2;
alter table hour add column orrunningtotal integer default -1;

--create table if not exists accumtime (
--  id integer not null primary key,
--  en text not null,
--  date integer,
--  hours integer,
--  orhours integer default -1,
--	suen text not null default '',
--	stime integer,
--	processed integer,
--  pc integer default 2
--);
-- alter table accumtime add column processed integer default 0;
-- alter table accumtime add column pc integer default 2;
-- alter table accumtime add column processed integer default 0;

-- table leave
create table if not exists leave (
  id integer not null primary key,
  fromdate integer,
  todate integer,
  en text not null default '',
  reason text not null default '',
  partial integer default 1,
  type integer,
	suen text not null default '',
	stime integer,
	scomment text not null default '',
	sdel integer,
	processed integer,
	pc integer default 2
);
alter table leave add column processed integer default 0;
alter table leave add column pc integer default 2;

-- table holiday
create table if not exists holiday (
  id integer not null primary key,
  date integer,
  desc text not null default '',
  pc integer default 0,
	auto integer default 0	
);
alter table holiday add column pc integer default 2;
alter table holiday add column auto integer default 0;

insert into holiday (id,date,desc) values (1,1230163200,'Christmas');

-- table leavetype
create table if not exists leavetype (
  id integer not null primary key,
  desc text not null,
  paid integer,
  flexi integer,
  cat integer,
  pc integer default 2,
	fgcolor integer default 16777215,
	bgcolor integer default 0,
	payrollcode text not null default '',
  expcode integer default 1	
);

alter table leavetype add column fgcolor integer default 16777215;
alter table leavetype add column bgcolor integer default 0;
alter table leavetype add column pc integer default 2;
alter table leavetype add column payrollcode text not null default '';
alter table leavetype add column expcode integer default 1;

insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (1, 'Paid Leave', 1, 0, 7, 16777215, 32896);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (2, 'Sick Leave', 1, 0, 8, 16777215, 16711680);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (3, 'Flexi Leave', 1, 1, 7, 16777215, 4243520);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (4, 'Unpaid Leave', 0, 0, 0, 16777215, 32768);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (5, 'Other Leave', 1, 0, 7, 16777215, 16711935);
insert into leavetype (id,desc,paid,flexi,cat, fgcolor, bgcolor) values (6, 'Family Responsibility', 1, 0, 7, 16777215, 255);

update leavetype set fgcolor=16777215, bgcolor=32896 where id =1 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=16711680 where id =2 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=4243520 where id =3 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=32768 where id =4 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=16711935 where id =5 and fgcolor = 16777215 and bgcolor = 0;
update leavetype set fgcolor=16777215, bgcolor=255 where id =6 and fgcolor = 16777215 and bgcolor = 0;

-- table gloproc
create table if not exists gloproc (
  id integer not null primary key,
  autoproc integer default 1,
  cat1 text not null default 'Extra',
  cat2 text not null default 'Normal',
  cat3 text not null default 'Overtime',
  cat4 text not null default 'Saturday',
  cat5 text not null default 'Sunday',
  cat6 text not null default 'Holiday',
  cat7 text not null default 'Paid Leave',
  cat8 text not null default 'Sick Leave',
  cat9 text not null default 'Variance',
  balancing integer default 1,
  rounding integer default 15,
  extracat integer default 1,
  normalcat integer default 2,
  overtimecat integer default 3,
  satcat integer default 4,
  suncat integer default 5,
  holidaycat integer default 6,
  variancecat integer default 9,
  sunday text not null default 'Sunday',
  monday text not null default 'Monday',
  tuesday text not null default 'Tuesday',
  wednesday text not null default 'Wednesday',
  thursday text not null default 'Thursday',
  friday text not null default 'Friday',
  saturday text not null default 'Saturday',
  lastdate integer default 0,
  autoendday integer default 1,
  runningtotals integer default 0,
  pc integer default 2,
  leaveautoapproved integer default 1,
  threshold1 integer default 0,
	threshold2 integer default 0,
	threshold3 integer default 0,
	threshold4 integer default 0,
	threshold5 integer default 0,
	threshold6 integer default 0,
	threshold7 integer default 0,
	threshold8 integer default 0,
	threshold9 integer default 0		
);
alter table gloproc add column autoendday integer default 1;
alter table gloproc add column runningtotals integer default 1;
alter table gloproc add column lastdate integer default 0;
alter table gloproc add column leaveautoapproved integer default 1;
alter table gloproc add column extracat integer default 1;
alter table gloproc add column normalcat integer default 2;
alter table gloproc add column overtimecat integer default 3;
alter table gloproc add column holidaycat integer default 6;
alter table gloproc add column variancecat integer default 9;
alter table gloproc add column pc integer default 2;  
alter table gloproc add column sunday text not null default 'Sunday';
alter table gloproc add column monday text not null default 'Monday';
alter table gloproc add column tuesday text not null default 'Tuesday';
alter table gloproc add column wednesday text not null default 'Wednesday';
alter table gloproc add column thursday text not null default 'Thursday';
alter table gloproc add column friday text not null default 'Friday'; 
alter table gloproc add column saturday text not null default 'Saturday';
alter table gloproc add column threshold1 integer default 0;
alter table gloproc add column threshold2 integer default 0;
alter table gloproc add column threshold3 integer default 0;
alter table gloproc add column threshold4 integer default 0;
alter table gloproc add column threshold5 integer default 0;
alter table gloproc add column threshold6 integer default 0;
alter table gloproc add column threshold7 integer default 0;
alter table gloproc add column threshold8 integer default 0;
alter table gloproc add column threshold9 integer default 0;
insert into gloproc (id) values (1);

-- table menucat
create table if not exists menucat (
	id integer not null primary key,
	catno integer,
	desc text not null,
	disabled integer default 0,
	pc integer default 2,
	language text not null default "english"
);
alter table menucat add column pc integer default 2;
alter table menucat add column language text not null default "english";
create unique index if not exists menucat_catkey on menucat(language,catno);

--delete from menucat where catno <> 8;			-- (may want to remove this from alter.sql later)
insert or replace into menucat (language, catno, desc) values ("english", 1, 'Clocking');
insert or replace into menucat (language, catno, desc) values ("english", 2, 'Enquiry');
insert or replace into menucat (language, catno, desc) values ("english", 3, 'Employee');
insert or replace into menucat (language, catno, desc) values ("english", 4, 'Super');
insert or replace into menucat (language, catno, desc) values ("english", 5, 'Admin');
insert or replace into menucat (language, catno, desc) values ("english", 6, 'Time');
insert or replace into menucat (language, catno, desc) values ("english", 7, 'Device');
-- menu cat 8 is reserved for user

-- table menuitem
create table if not exists menuitem (
	id integer not null primary key,
	catno integer,
	itemno integer,
	desc text not null,
	seqid integer,
	disabled integer default 0,
	pc integer default 2,
	language text not null default "english"
);
alter table menuitem add column pc integer default 2;
alter table menuitem add column language text not null default "english";
create unique index if not exists menuitem_catitemkey on menuitem(language,catno,itemno);

delete from menuitem where catno <> 8;			-- (may want to remove this from alter.sql later)

insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",1, 1, 'Payroll Only', -251);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",1, 2, 'Access Only', -250);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",1, 3, 'Job', -252);

insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",2, 1, 'Employee Status', -410);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",2, 2, 'Clock Status', -500);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",2, 3, 'Employee List', -421);

insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",3, 1, 'New Employee', -300);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",3, 2, 'Delete Employee', -401);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",3, 3, 'Add Fingerprint', -302);

insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",4, 1, 'Assign Card', -300);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",4, 2, 'Remove Card', -301);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",4, 3, 'Export USB/Excel', -701);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",4, 4, 'Set Emp Department', -434);

insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",5, 1, 'Sync PC via USB', -700);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",5, 2, 'Employee Level', -435);

insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",6, 1, 'Get Internet Time', -600);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",6, 2, 'Set Time', -601);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",6, 3, 'Set Date', -602);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",6, 4, 'Set Time Zone', -603);

insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",7, 1, 'Backup Database', -704);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",7, 2, 'Network Settings', -505);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",7, 3, 'Update Firmware', -810);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",7, 4, 'Lock/Unlock clock', -705);

insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",9, 1, 'Reboot / Shutdown', -490);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",9, 2, 'Restore Database', -703);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",9, 3, 'Set History Days', -707);
insert or replace  into menuitem (language, catno, itemno, desc, seqid) values ("english",9, 4, 'Set Language', -604);
insert  or replace into menuitem (language, catno, itemno, desc, seqid) values ("english",9, 9, 'Test Relays', -816);
update menuitem set language = "english", seqid=-604, desc = 'Set Language' where catno = 9 and itemno = 4;

-- 8 characters allowed for menu names
-- -----------------------------------
insert or replace into menucat (language, catno, desc) values ("danish", 1, 'Stemp.');
insert or replace into menucat (language, catno, desc) values ("danish", 2, 'Foresp.');
insert or replace into menucat (language, catno, desc) values ("danish", 3, 'Medarb.');
insert or replace into menucat (language, catno, desc) values ("danish", 4, 'Super');
insert or replace into menucat (language, catno, desc) values ("danish", 5, 'Admin');
insert or replace into menucat (language, catno, desc) values ("danish", 6, 'Klokken');
insert or replace into menucat (language, catno, desc) values ("danish", 7, 'Enhed');

-- 20 characters allowed for menu items
-- ------------------------------------
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",1, 1, 'Kun loen', -251);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",1, 2, 'Kun adgang', -250);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",1, 3, 'Job', -252);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",2, 1, 'Medarbejder status', -410);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",2, 2, 'Ur status', -500);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",2, 3, 'Medarbejder liste', -421);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",3, 1, 'Ny medarbejder', -300);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",3, 2, 'Slet medarbejder', -401);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",3, 3, 'Tilfoej fingeraftryk', -302);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",4, 1, 'Tilfoej kort', -300);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",4, 2, 'Slet kort', -301);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",4, 3, 'Eksport USB/Excel', -701);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",4, 4, 'Saet med. afdeling', -434);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",5, 1, 'Sync PC via USB', -700);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",5, 2, 'Medarbejder niveau', -435);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",6, 1, 'Hent internet tid', -600);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",6, 2, 'Stil klokke', -601);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",6, 3, 'Stil dato', -602);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",6, 4, 'Opsaet tids zone', -603);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",7, 1, 'Backup Database', -704);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",7, 2, 'Netvaerks indst.', -505);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",7, 3, 'Updater firmware', -810);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",7, 4, 'Lock/Unlock clock', -705);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",9, 1, 'Reboot / Shutdown', -490);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",9, 2, 'Restore Database', -703);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",9, 3, 'Stil historik dage', -707);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("danish",9, 4, 'Vaelg sprog', -604);

-- -------------------------------------------------------------------------------------------------------------
-- 8 characters allowed for menu names
-- -----------------------------------
insert or replace into menucat (language, catno, desc) values ("spanish", 1, 'Ingresos');
insert or replace into menucat (language, catno, desc) values ("spanish", 2, 'Consulta');
insert or replace into menucat (language, catno, desc) values ("spanish", 3, 'Empleado');
insert or replace into menucat (language, catno, desc) values ("spanish", 4, 'Supervis');
insert or replace into menucat (language, catno, desc) values ("spanish", 5, 'Administ');
insert or replace into menucat (language, catno, desc) values ("spanish", 6, 'Hora');
insert or replace into menucat (language, catno, desc) values ("spanish", 7, 'Equipo');

-- 20 characters allowed for menu items
-- ------------------------------------
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",1, 1, 'Solo nomina', -251);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",1, 2, 'Solo acceso', -250);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",1, 3, 'Trabajo', -252);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",2, 1, 'Estatus del empleado', -410);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",2, 2, 'Estaus del reloj', -500);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",2, 3, 'Lista de empleados', -421);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",3, 1, 'Nuevo empleado', -300);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",3, 2, 'Borrar empleado', -401);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",3, 3, 'Agregar huella', -302);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",4, 1, 'Asignar tarjeta', -300);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",4, 2, 'Remover tarjeta', -301);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",4, 3, 'Exportar USB/Excel', -701);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",4, 4, 'Ajusta Emp Departam', -434);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",5, 1, 'Sync PC via USB', -700);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",5, 2, 'Nivel de empleado', -435);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",6, 1, 'Obtener hora Internet', -600);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",6, 2, 'Ajustar hora', -601);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",6, 3, 'Ajustar fecha', -602);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",6, 4, 'Ajustar zona horaria', -603);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",7, 1, 'Respaldar Base datos', -704);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",7, 2, 'Configuracion Red', -505);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",7, 3, 'Actualiza Firmware', -810);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",7, 4, 'Bloq/Desbloq reloj', -705);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",9, 1, 'Reinicia / Apagar', -490);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",9, 2, 'Restituir Base datos', -703);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",9, 3, 'Ajusta dias historia', -707);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("spanish",9, 4, 'Ajusta Lenguaje', -604);


-- 8 characters allowed for menu names
-- -----------------------------------

insert or replace into menucat (language, catno, desc) values ("afrikaans", 1, 'Kloktye');
insert or replace into menucat (language, catno, desc) values ("afrikaans", 2, 'Navraag');
insert or replace into menucat (language, catno, desc) values ("afrikaans", 3, 'Werker');
insert or replace into menucat (language, catno, desc) values ("afrikaans", 4, 'Bestuur');
insert or replace into menucat (language, catno, desc) values ("afrikaans", 5, 'Admin');
insert or replace into menucat (language, catno, desc) values ("afrikaans", 6, 'Tyd');
insert or replace into menucat (language, catno, desc) values ("afrikaans", 7, 'Toestel');

-- 20 characters allowed for menu items
-- ------------------------------------

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",1, 1, 'Nuwe Loon kloktyd', -251);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",1, 2, 'Nuwe Toegang kloktyd', -250);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",1, 3, 'Nuwe Stukwerk tyd', -252);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",2, 1, 'Werknemer Status', -410);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",2, 2, 'Klok Status', -500);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",2, 3, 'Werknemer Lys', -421);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",3, 1, 'Nuwe Werknemer', -300);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",3, 2, 'Verwyder Werknemer', -401);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",3, 3, 'Nuwe Vingerafdruk', -302);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",4, 1, 'Ken Kaart toe', -300);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",4, 2, 'Verwyder kaart', -301);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",4, 3, 'Laai af na USB/Excel', -701);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",4, 4, 'Stel Werker Dept', -434);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",5, 1, 'Sinkroniseer via USB', -700);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",5, 2, 'Werknemer Vlak', -435);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",6, 1, 'Kry Internet Tyd', -600);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",6, 2, 'Verstel Tyd', -601);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",6, 3, 'Verstel Datum', -602);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",6, 4, 'Stel Tydsone', -603);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",7, 1, 'Maak Dekkopie na USB', -704);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",7, 2, 'Netwerk Instellings', -505);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",7, 3, 'Opdateer Klok', -810);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",7, 4, 'Sluit/Ontsluit Klok', -705);

insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",9, 1, 'Herlaai / Sit Af', -490);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",9, 2, 'Laai Dekkopie', -703);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",9, 3, 'Stel Stoorperiode', -707);
insert or replace into menuitem (language, catno, itemno, desc, seqid) values ("afrikaans",9, 4, 'Kies Taal', -604);

-- table payroll
create table if not exists payroll (
	id integer not null primary key,
	name text not null default '',
	phpname text not null default '',
	csvname text not null default '',
	sitecode text not null default '',
	fromdate integer not null default 0, 
	todate integer not null default 0,
	catcode1 text not null default '',
	catcode2 text not null default '',
	catcode3 text not null default '',
	catcode4 text not null default '',
	catcode5 text not null default '',
	catcode6 text not null default '',
	catcode7 text not null default '',
	catcode8 text not null default '',
	catcode9 text not null default '',
	expcode1 integer not null default 1,
	expcode2 integer not null default 1,
	expcode3 integer not null default 1,
	expcode4 integer not null default 1,
	expcode5 integer not null default 1,
	expcode6 integer not null default 1,
	expcode7 integer not null default 1,
	expcode8 integer not null default 1,
	expcode9 integer not null default 1,
	defaultexp integer not null default 0,
	stdtime1 integer not null default 0,
	cat1intime1 integer not null default 1,
	cat2intime1 integer not null default 0,
	cat3intime1 integer not null default 0,
	cat4intime1 integer not null default 0,
	cat5intime1 integer not null default 0,
	cat6intime1 integer not null default 0,
	cat7intime1 integer not null default 0,
	cat8intime1 integer not null default 0,
	cat9intime1 integer not null default 0,
	time1overflowcat integer not null default 0,
	time1getfrom1 integer not null default 0,
	time1getfrom2 integer not null default 0,
	time1getfrom3 integer not null default 0,
	time1getfrom4 integer not null default 0,
	stdtime2 integer not null default 0,
	cat1intime2 integer not null default 0,
	cat2intime2 integer not null default 1,
	cat3intime2 integer not null default 0,
	cat4intime2 integer not null default 0,
	cat5intime2 integer not null default 0,
	cat6intime2 integer not null default 0,
	cat7intime2 integer not null default 0,
	cat8intime2 integer not null default 0,
	cat9intime2 integer not null default 0,
	time2overflowcat integer not null default 0,
	time2getfrom1 integer not null default 0,
	time2getfrom2 integer not null default 0,
	time2getfrom3 integer not null default 0,
	time2getfrom4 integer not null default 0,
	stdtime3 integer not null default 0,
	cat1intime3 integer not null default 0,
	cat2intime3 integer not null default 0,
	cat3intime3 integer not null default 1,
	cat4intime3 integer not null default 0,
	cat5intime3 integer not null default 0,
	cat6intime3 integer not null default 0,
	cat7intime3 integer not null default 0,
	cat8intime3 integer not null default 0,
	cat9intime3 integer not null default 0,
	time3overflowcat integer not null default 0,
	time3getfrom1 integer not null default 0,
	time3getfrom2 integer not null default 0,
	time3getfrom3 integer not null default 0,
	time3getfrom4 integer not null default 0,
	stdtime4 integer not null default 0,
	cat1intime4 integer not null default 0,
	cat2intime4 integer not null default 0,
	cat3intime4 integer not null default 0,
	cat4intime4 integer not null default 1,
	cat5intime4 integer not null default 0,
	cat6intime4 integer not null default 0,
	cat7intime4 integer not null default 0,
	cat8intime4 integer not null default 0,
	cat9intime4 integer not null default 0,
	time4overflowcat integer not null default 0,
	time4getfrom1 integer not null default 0,
	time4getfrom2 integer not null default 0,
	time4getfrom3 integer not null default 0,
	time4getfrom4 integer not null default 0,
	overridecat1 integer not null default 0,
	overridecat2 integer not null default 0,
	overridecat3 integer not null default 0,
	overridecat4 integer not null default 0,
	overridecat5 integer not null default 0,
	overridecat6 integer not null default 0,
	overridecat7 integer not null default 0,
	overridecat8 integer not null default 0,
	overridecat9 integer not null default 0,
	overridetime1 integer not null default 0,
	overridetime2 integer not null default 0,
	overridetime3 integer not null default 0,
	overridetime4 integer not null default 0,
	overridetime5 integer not null default 0,
	overridetime6 integer not null default 0,
	overridetime7 integer not null default 0,
	overridetime8 integer not null default 0,
	overridetime9 integer not null default 0
);	
alter table payroll add column defaultexp integer not null default 0;
alter table payroll add column stdtime1 integer not null default 0;
alter table payroll add column cat1intime1 integer not null default 0;
alter table payroll add column cat2intime1 integer not null default 1;
alter table payroll add column cat3intime1 integer not null default 1;
alter table payroll add column cat4intime1 integer not null default 0;
alter table payroll add column cat5intime1 integer not null default 0;
alter table payroll add column cat6intime1 integer not null default 1;
alter table payroll add column cat7intime1 integer not null default 1;
alter table payroll add column cat8intime1 integer not null default 1;
alter table payroll add column cat9intime1 integer not null default 0;
alter table payroll add column time1overflowcat integer not null default 0;
alter table payroll add column time1getfrom1 integer not null default 0;
alter table payroll add column time1getfrom2 integer not null default 0;
alter table payroll add column time1getfrom3 integer not null default 0;
alter table payroll add column time1getfrom4 integer not null default 0;
alter table payroll add column stdtime2 integer not null default 0;
alter table payroll add column cat1intime2 integer not null default 0;
alter table payroll add column cat2intime2 integer not null default 0;
alter table payroll add column cat3intime2 integer not null default 0;
alter table payroll add column cat4intime2 integer not null default 0;
alter table payroll add column cat5intime2 integer not null default 0;
alter table payroll add column cat6intime2 integer not null default 0;
alter table payroll add column cat7intime2 integer not null default 0;
alter table payroll add column cat8intime2 integer not null default 0;
alter table payroll add column cat9intime2 integer not null default 0;
alter table payroll add column time2overflowcat integer not null default 0;
alter table payroll add column time2getfrom1 integer not null default 0;
alter table payroll add column time2getfrom2 integer not null default 0;
alter table payroll add column time2getfrom3 integer not null default 0;
alter table payroll add column time2getfrom4 integer not null default 0;
alter table payroll add column stdtime3 integer not null default 0;
alter table payroll add column cat1intime3 integer not null default 0;
alter table payroll add column cat2intime3 integer not null default 0;
alter table payroll add column cat3intime3 integer not null default 0;
alter table payroll add column cat4intime3 integer not null default 0;
alter table payroll add column cat5intime3 integer not null default 0;
alter table payroll add column cat6intime3 integer not null default 0;
alter table payroll add column cat7intime3 integer not null default 0;
alter table payroll add column cat8intime3 integer not null default 0;
alter table payroll add column cat9intime3 integer not null default 0;
alter table payroll add column time3overflowcat integer not null default 0;
alter table payroll add column time3getfrom1 integer not null default 0;
alter table payroll add column time3getfrom2 integer not null default 0;
alter table payroll add column time3getfrom3 integer not null default 0;
alter table payroll add column time3getfrom4 integer not null default 0;
alter table payroll add column stdtime4 integer not null default 0;
alter table payroll add column cat1intime4 integer not null default 0;
alter table payroll add column cat2intime4 integer not null default 0;
alter table payroll add column cat3intime4 integer not null default 0;
alter table payroll add column cat4intime4 integer not null default 0;
alter table payroll add column cat5intime4 integer not null default 0;
alter table payroll add column cat6intime4 integer not null default 0;
alter table payroll add column cat7intime4 integer not null default 0;
alter table payroll add column cat8intime4 integer not null default 0;
alter table payroll add column cat9intime4 integer not null default 0;
alter table payroll add column time4overflowcat integer not null default 0;
alter table payroll add column time4getfrom1 integer not null default 0;
alter table payroll add column time4getfrom2 integer not null default 0;
alter table payroll add column time4getfrom3 integer not null default 0;
alter table payroll add column time4getfrom4 integer not null default 0;
alter table payroll add column overridecat1 integer not null default 0;
alter table payroll add column overridecat2 integer not null default 0;
alter table payroll add column overridecat3 integer not null default 0;
alter table payroll add column overridecat4 integer not null default 0;
alter table payroll add column overridecat5 integer not null default 0;
alter table payroll add column overridecat6 integer not null default 0;
alter table payroll add column overridecat7 integer not null default 0;
alter table payroll add column overridecat8 integer not null default 0;
alter table payroll add column overridecat9 integer not null default 0;
alter table payroll add column overridetime1 integer not null default 0;
alter table payroll add column overridetime2 integer not null default 0;
alter table payroll add column overridetime3 integer not null default 0;
alter table payroll add column overridetime4 integer not null default 0;
alter table payroll add column overridetime5 integer not null default 0;
alter table payroll add column overridetime6 integer not null default 0;
alter table payroll add column overridetime7 integer not null default 0;
alter table payroll add column overridetime8 integer not null default 0;
alter table payroll add column overridetime9 integer not null default 0;

-- table seq
create table if not exists seq (
	id integer not null primary key,
	seqid integer,
	author text not null default '',
	name text not null default '',
	version integer,
	editdate integer,
	pc integer,
	compiled integer,
	notes text not null default '',
	bundy text not null default '',
	pcode text not null default ''
);
alter table seq add column il text not null default '';

-- table company
create table if not exists company (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);

-- table branch
create table if not exists branch (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);

-- table dept
create table if not exists dept (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);
alter table dept add column pc integer default 2;

-- table center
create table if not exists center (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);

-- table cat
create table if not exists cat (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);

-- table payscale
create table if not exists payscale (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);

-- table emptype
create table if not exists emptype (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);

-- table workgroup
create table if not exists workgroup (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);

-- table job
create table if not exists job (
	id integer not null primary key,
	desc text not null default '',
	pc integer default 2
);


-- table emp
alter table emp add column companyid integer default 0;
alter table emp add column branchid integer default 0;
alter table emp add column centerid integer default 0;
alter table emp add column catid integer default 0;
alter table emp add column scaleid integer default 0;
alter table emp add column emptypeid integer default 0;
alter table emp add column workgroupid integer default 0;
alter table emp add column jobid integer default 0;
alter table emp add column payid text not null default '';
alter table emp add column payexporttype integer not null default 0;

create index if not exists emp_exdatekey on emp(exdate);

-- table thisdev
alter table thisdev add column special integer default 0;
alter table thisdev add column dateformat integer default 6;
alter table thisdev add column advancedhw integer default 0;
alter table thisdev add column accessoptions integer default 0;
alter table thisdev add column joboptions integer default 0;
alter table thisdev add column csvdays integer default 0;
alter table thisdev add column refreshdb integer not null default 0;
alter table thisdev add column hrsindec integer default 0;
alter table thisdev add column maxemployees integer default 0;
alter table thisdev add column webmaster integer default 0;
alter table thisdev add column csvdecimal integer default 1;
alter table thisdev add column defaultseq integer default -100;
alter table thisdev add column holidayregion text not null default '';
alter table thisdev add column pc integer not null default 2;
alter table thisdev add column ishost integer not null default 0;
alter table thisdev add column hostpollseconds integer not null default 120;
alter table thisdev add column hostsyncseconds integer not null default 120;
alter table thisdev add column hostpropogateseconds integer not null default 300;
alter table thisdev add column allowoverridelogin integer default 1;
alter table thisdev add column language text not null default 'english';
-- table otherdev
alter table otherdev add column desc text not null default '';
alter table otherdev add column pc integer default 2;

-- table card
alter table card add column fpsec integer not null default 1;
alter table card add column fp text not null default '';
alter table card add column fpf integer not null default 0;
alter table card add column fpl integer not null default 0;
alter table card add column fpcrc integer not null default 0;

--update card set lcn = 902, ecn = 902, scn = '0000000902' where lcn = 901 and seqid = -420 and pc = 0;	-- Show Emp Number (do this one first)
update card set lcn = 901, ecn = 901, scn = '0000000901' where lcn = 900 and seqid = -410 and pc = 0;	-- Show Emp Details

insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (900, 900, '0000000900', '', 0, 0, -180);	-- Menu
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (930, 930, '0000000930', '', 0, 0, -600);	-- Get Internet Time
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (931, 931, '0000000931', '', 0, 0, -601);	-- Set Time
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (932, 932, '0000000932', '', 0, 0, -602);	-- Set Date
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (933, 933, '0000000933', '', 0, 0, -603);	-- Set TimeZone

insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (944, 944, '0000000944', '', 0, 0, -816);	-- Self Test

insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (951, 951, '0000000951', '', 0, 0, -701);	-- USB export CSV
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (959, 959, '0000000959', '', 0, 0, -702);	-- USB Run Command
-- insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (938, 938, '0000000938', '', 0, 0, -495);	-- Set Serial Number ** obsolete **
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (939, 939, '0000000939', '', 0, 0, -490);	-- Reboot
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (986, 986, '0000000986', '', 0, 0, -401);	-- Remove Employee
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (987, 987, '0000000987', '', 0, 0, -301);	-- Remove Card
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (960, 960, '0000000960', '', 0, 0, -800);	-- Application Update Clock (via Web)
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (961, 961, '0000000961', '', 0, 0, -801);	-- Application Update Clock via Memory Stick
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (962, 962, '0000000962', '', 0, 0, -802);	-- Force Application Update Clock (via Web)
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (963, 963, '0000000963', '', 0, 0, -803);	-- Force Application Update Clock via Memory Stick
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (965, 965, '0000000965', '', 0, 0, -805);	-- Set Application Update to use Release Build
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (966, 966, '0000000966', '', 0, 0, -806);	-- Set Application Update to use Beta Build
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (967, 967, '0000000967', '', 0, 0, -807);	-- Set Application Update to use Alpha Build
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (968, 968, '0000000968', '', 0, 0, -808);	-- Set Application Update to use Gamma Build
-- ------------------------------------------------ --
-- CARDS 970 through 979 reserved for Button-Reader --
-- ------------------------------------------------ --
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (982, 982, '0000000982', '', 0, 0, -430);	-- Promote Employee to Admin
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (983, 983, '0000000983', '', 0, 0, -431);	-- Demote Admin (Employee)
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (984, 984, '0000000984', '', 0, 0, -432);	-- Promote Employee to Supervisor
--insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (985, 985, '0000000985', '', 0, 0, -433);	-- Demote Supervisor (Employee)
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (958, 958, '0000000958', '', 0, 0, -703);	-- USB Restore (DB)
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (991, 991, '0000000991', '', 0, 0, -10);	-- Backup Clock to USB and Internet
insert into card (lcn, ecn, scn, en, pc, cnv, seqid) values (998, 998, '0000000998', '', 0, 0, -815);	-- Sync FP



-- table daughter
alter table daughter add column descf1 text not null default '';
alter table daughter add column desc1 text not null default '';
alter table daughter add column desc2 text not null default '';
alter table daughter add column desc3 text not null default '';
alter table daughter add column comportf1 integer not null default -1;
alter table daughter add column defaulttimezone integer not null default 0;
alter table daughter add column overridetimezone integer not null default 0;
alter table daughter add column timezoneoninonly integer not null default 0;
alter table daughter add column caf1 integer not null default 0;
alter table daughter add column paf1 integer not null default 0;
alter table daughter add column ca1 integer not null default 0;
alter table daughter add column pa1 integer not null default 0;
alter table daughter add column ca2 integer not null default 0;
alter table daughter add column pa2 integer not null default 0;
alter table daughter add column ca3 integer not null default 0;
alter table daughter add column pa3 integer not null default 0;
alter table daughter add column locked integer not null default 0;
alter table daughter add column defaultnoaccess integer not null default 0;
alter table daughter add column pc integer not null default 2;
alter table daughter add column online integer not null default 0;
alter table daughter add column defaultpayroll integer not null default 1;

-- fingerprint reader	2 (could be any serial reader - eg barcode)
alter table daughter add column comportf2 integer not null default -1;
alter table daughter add column descf2 text not null default '';
alter table daughter add column tyf2 integer not null default 0;
alter table daughter add column tdf2 integer not null default 0;
alter table daughter add column aef2 integer not null default 0;
alter table daughter add column caf2 integer not null default 0;
alter table daughter add column paf2 integer not null default 0;
alter table daughter add column inf2 integer not null default 0;
alter table daughter add column outf2 integer not null default 0;
alter table daughter add column daf2 integer not null default 0;
alter table daughter add column inrbf2 integer not null default 0;
alter table daughter add column outrbf2 integer not null default 0;
alter table daughter add column inarbf2 integer not null default 0;
alter table daughter add column outarbf2 integer not null default 0;



create table if not exists timezoneset (
	id integer not null primary key,
	desc text not null default '',
  pc integer not null default 2
)	;

-- table timezone
create table if not exists timezone (
	id integer not null primary key,
	setid integer not null default 0,
	num integer not null default 1,
	desc text not null default '',
	monstart integer not null default -1,
	monend integer not null default -1,
	tuestart integer not null default -1,
	tueend integer not null default -1,
	wedstart integer not null default -1,
	wedend integer not null default -1,
	thustart integer not null default -1,
	thuend integer not null default -1,
	fristart integer not null default -1,
	friend integer not null default -1,
	satstart integer not null default -1,
	satend integer not null default -1,
	sunstart integer not null default -1,
	sunend integer not null default -1,
	pc integer not null default 0
);
alter table timezone add column setid integer not null default 0;
alter table timezone add column num integer not null default 1;
insert into timezoneset (id,desc) select id,id from timezone where setid=0;
update timezone set setid = id where setid = 0;


-- table empaccess
create table if not exists empaccess (
	id integer not null primary key,
	en text not null default '',
	serial integer not null default 0,
	access integer not null default 1,
	accessout integer not null default 1,
  payroll integer not null default -1,	
	timezoneid integer not null default 0,	
	pc integer not null default 0,
	pathing integer not null default -1,
	lockdoor integer not null default 0,
	opendoor integer not null default 1
);
create index if not exists empaccess_enkey on empaccess(en,access,timezoneid);

alter table empaccess add column pathing integer not null default -1;
alter table empaccess add column lockdoor integer not null default 0;
alter table empaccess add column opendoor integer not null default -1;
alter table empaccess add column accessout integer not null default 1;
alter table empaccess add column payroll integer not null default -1;

alter table card add column fpsec integer not null default 1;
-- -------------------------------------------------------------------------------------------------------------------------------------------------
-- Keep this at the bottom of the file - it is automatically adjusted via versionchange.sh (Do not edit)
-- -------------------------------------------------------------------------------------------------------------------------------------------------
update _info set dbversion = 2012;
-- -------------------------------------------------------------------------------------------------------------------------------------------------




