#!/bin/sh

# ---------------------------------------------------------------------------------------
# Terminal colors
NORMAL='\033[0m'
#GOOD='\033[32;01m'
GOOD='\033[33;01m'
BAD='\033[31;01m'

# ---------------------------------------------------------------------------------------
msg() {
	echo -e "${GOOD}Updater: ${NORMAL} $*"
}

# ---------------------------------------------------------------------------------------
msg_error() {
	echo -e "${BAD}Updater Error: ${NORMAL} $*"
}

# ---------------------------------------------------------------------------------------

close_clock_apps() {
	msg "Preparing to stop processes..."
	#---------------------
	# Fix for bug introduced in v1.13b (13 June 2008)
	#---------------------
	sed -i '/killall -9 updateclock/d' /etc/init.d/clock
	sed -i '/killall -9 clock_update.sh/d' /etc/init.d/clock
	# this doesn's seem to work so bruce added
	sed -i "s/killall -9 updateclock/ps/" /etc/init.d/clock
	sed -i "s/killall -9 clock_update/ps/" /etc/init.d/clock

	msg "Stopping Clock Processes..."
	export update_memstick=1
	/usr/local/bin/stopclock
	msg "Stopping Clock Processes... (Double check)"
	sleep 1
	killall watchdog > /dev/null 2>&1
	killall rdate > /dev/null 2>&1
	msg "Stopping Clock Processes... (Triple check)"
	sleep 1
	killall -9 watchdog > /dev/null 2>&1
	killall -9 host > /dev/null 2>&1
	killall -9 clockos > /dev/null 2>&1
	killall -9 pcserver > /dev/null 2>&1
	killall -9 replicate > /dev/null 2>&1
	killall -9 php-cgi > /dev/null 2>&1

	msg "Listing Running Processes..."
	ps
}


# -----------------------------------------------------------------------------
# Automatically updated Version Numbers - do not edit (generated from build.sh)
# -----------------------------------------------------------------------------
CLOCK_BUILD_NUMBER=1225
CLOCK_VERSION=1.22e

CA_CERT=/usr/local/share/trustedcerts/cacerts.crt
WGET_OPTIONS="-T 6 -t 2 --ca-certificate $CA_CERT"

if grep UPDATE_TYPE=alpha /usr/local/bin/updateclock >/dev/null ; then 
	msg_error "Changing default update type in old script to Release..."
	sed -i 's/UPDATE_TYPE=alpha/UPDATE_TYPE=release/' /usr/local/bin/updateclock
	msg_error "We will now attempt to run the update process again..."
	exec /usr/local/bin/updateclock
	# Should not get here....
	return 1
fi	


UPDATE_CONFIG=/var/local/data/update_type
# -----------------------------------------------------
# UPDATE_TYPE can be either: release, beta, or alpha
# -----------------------------------------------------
if [ -s $UPDATE_CONFIG ]; then
	. $UPDATE_CONFIG
fi	
UPDATE_TYPE=${UPDATE_TYPE-release}

DOWNLOAD_FILE_NAME=new.tar.gz
SECURE_DOWNLOAD_FILE=https://www.capefox.com/secure/clocks/$UPDATE_TYPE/$DOWNLOAD_FILE_NAME

if [ "$1" = "--memstick" ]; then
	memstick=1
else 
	if [ "$2" = "--memstick" ]; then
		memstick=1
	else 
		memstick=0
	fi
fi

if [ "$1" = "--vartmp" ]; then
	vartmp=1
else 
	if [ "$2" = "--vartmp" ]; then
		vartmp=1
	else 
		vartmp=0
	fi
fi


if [ "$1" = "--force" ]; then
	force=1
else 
	if [ "$2" = "--force" ]; then
		force=1
	else 
		force=0
	fi
fi

if [ "$memstick" -eq 1 ]; then
	MEMSTICK_MOUNT_POINT=/mnt/1
	SECURE_DOWNLOAD_FILE=$MEMSTICK_MOUNT_POINT/$UPDATE_TYPE/$DOWNLOAD_FILE_NAME
	TEMP_UPDATES_DIR=/var/tmp/clock_updates
	NEW_FILE_VERSION=/var/local/updates/clock_update_new_version
else 
  if [ "$vartmp" -eq 1 ]; then
	  SECURE_DOWNLOAD_FILE=var/tmp/$UPDATE_TYPE/$DOWNLOAD_FILE_NAME
		TEMP_UPDATES_DIR=/var/tmp/$UPDATE_TYPE
		NEW_FILE_VERSION=/var/tmp/$UPDATE_TYPE/new.txt
	else
		SECURE_DOWNLOAD_FILE=https://www.capefox.com/secure/clocks/$UPDATE_TYPE/$DOWNLOAD_FILE_NAME
		TEMP_UPDATES_DIR=/var/tmp/clock_updates
		NEW_FILE_VERSION=/var/local/updates/clock_update_new_version
	fi	
fi




TEMP_EXTRACT_DIR=$TEMP_UPDATES_DIR/extract
DOWNLOAD_FILE=$TEMP_UPDATES_DIR/$DOWNLOAD_FILE_NAME


DATABASE=/var/local/data/capeclock.db

# -----------------------------------------------------------------------------
# Startup
# -----------------------------------------------------------------------------
msg "Updating the Clock to Version $CLOCK_VERSION (Build $CLOCK_BUILD_NUMBER)"
msg "Update Type: $UPDATE_TYPE"

mkdir -p $TEMP_UPDATES_DIR
# -----------------------------------------------------------------------------
# download all the compressed files necessary to perform the update
# do not need to decompress the files.
# -----------------------------------------------------------------------------
if [ "$memstick" -eq 1 ]; then
	mount_usb
  result=`mount | grep /mnt/1`
  if [ -n "$result" ];
  then
	  echo usb drive found
  else
    echo update failed usb drive not found
    exit 1 # fail
  fi	

	#mount -t vfat -o umask=0000 /dev/sda1 $MEMSTICK_MOUNT_POINT
	msg "Downloading File Updates from the Memory Stick..."
	cp -f $SECURE_DOWNLOAD_FILE $DOWNLOAD_FILE
else
	if [ "$vartmp" -eq 1 ]; then
		msg "File should already be in /var/tmp"
	else
		close_clock_apps
		msg "Downloading File Updates from the Web..."
		wget $WGET_OPTIONS -O $DOWNLOAD_FILE $SECURE_DOWNLOAD_FILE
	fi	
fi 
if [ $? -ne 0 ]; then         # Test exit status of wget command.
	msg_error "Could Not Download File Updates"
	rm -f $DOWNLOAD_FILE > /dev/null 2>&1
	exit 1
fi
chmod 0600 $DOWNLOAD_FILE
if [ "$memstick" -eq 1 ]; then
	umount $MEMSTICK_MOUNT_POINT > /dev/null 2>&1
fi
if [ ! -s  $DOWNLOAD_FILE ]; then         
	msg_error "Could Not Download File Updates"
	rm -f $DOWNLOAD_FILE > /dev/null 2>&1
	exit 1
fi

# -----------------------------------------------------------------------------
# Check hash - hey wow man....
# -----------------------------------------------------------------------------
sha_a=`sha1sum $DOWNLOAD_FILE`
sha_b=`sed -n "/$DOWNLOAD_FILE_NAME/s|$DOWNLOAD_FILE_NAME|$DOWNLOAD_FILE|p" $NEW_FILE_VERSION`
msg "Download: $sha_a"
msg "Orig    : $sha_b"
if [ "$sha_a" != "$sha_b" ]; then
	msg_error "The downloaded file ($DOWNLOAD_FILE) does not match the Check Sum!! The downloaded files will be deleted. Please try again later."
	rm -f $DOWNLOAD_FILE > /dev/null 2>&1
	rm -f $NEW_FILE_VERSION
	exit 1
fi 

# -----------------------------------------------------------------------------
# now all processes have to be terminated
# given a bit of time killing the watchdog should terminate all the other processes.
# -----------------------------------------------------------------------------
msg "Stopping Web Server in 10 seconds...."
sleep 10
msg "Stopping Web Server now"
/etc/init.d/httpd stop
msg "Stopping php"
killall php-cgi > /dev/null 2>&1

close_clock_apps

# -----------------------------------------------------------------------------
# Delete any files that are now obsolete
# -----------------------------------------------------------------------------
msg "Removing Outdated Files..."
rm -f /usr/local/lib/libsqlite3-3.4.1.so.1
rm -f /usr/local/lib/libsqlite3-3.5.8.so.1
rm -f /usr/local/lib/libusb-0.1.so.0.1.10a
rm -f /etc/init.d/boottime/clock_init.sh
rm -f /usr/local/bin/finger
rm -f /usr/local/lib/libusb-0.1.so.0.1.12
rm -f /usr/local/lib/libusb-0.1.so.4
rm -f /usr/local/lib/libusb.so
rm -f /usr/local/lib/libfingerfox.so.1
rm -f /usr/local/lib/libfingerfox.so.0.0.3
rm -f /usr/local/lib/libfingerfox.so

rm -f /usr/local/lib/libsqlite3.so.3.5.8
rm -f /var/local/www/scripts/tables.js
rm -f /var/local/www/images/Thumbs.db
rm -f /var/local/www/images/access.png
rm -f /var/local/www/images/access16.png
rm -f /var/local/www/images/browse.gif
rm -f /var/local/www/images/cslogoEco.jpg
rm -f /var/local/www/images/job.png
rm -f /var/local/www/images/job16.png
rm -f /var/local/www/images/mytime.png
rm -f /var/local/www/images/process.png
rm -f /var/local/www/images/setup.png
rm -f /var/local/www/clockpeers.php
rm -f /var/local/www/csvexport.php
rm -f /var/local/www/dprochours.php
rm -f /var/local/www/empcards.php
rm -f /var/local/www/empclockings.php
rm -f /var/local/www/empdhours.php
rm -f /var/local/www/emptest.php
rm -f /var/local/www/mycards.php
rm -f /var/local/www/myclockings.php
rm -f /var/local/www/mydetails.php
rm -f /var/local/www/mydhours.php
rm -f /var/local/www/myphours.php
rm -f /var/local/www/admin.html

# -----------------------------------------------------------------------------
# Uncompress file, part 1
# -----------------------------------------------------------------------------
msg "Getting ready to Extracting Update Files..."
rm -rf $TEMP_EXTRACT_DIR
mkdir -p $TEMP_EXTRACT_DIR
msg "Extracting Update Files..."
tar -xvzf $DOWNLOAD_FILE -C $TEMP_EXTRACT_DIR var/local
if [ $? -ne 0 ]; then         
	msg_error "Extracting $DOWNLOAD_FILE failed."
	exit 1
fi
msg "Extracting Update Files - Done"
#rm -f $DOWNLOAD_FILE


# -----------------------------------------------------------------------------
# Copy files part 1
# -----------------------------------------------------------------------------

msg "Updating /var/local/ from $TEMP_EXTRACT_DIR/var/local"
msg "cp -rf $TEMP_EXTRACT_DIR/var/local/* /var/local/"
cp -rf $TEMP_EXTRACT_DIR/var/local/* /var/local/
#if [ $? -ne 0 ]; then         
#	msg_error "Updating /var/local/ ... failed."
#	exit 1
#fi

#exit 0 # debugging remove me

# -----------------------------------------------------------------------------
# Uncompress file, part 2
# -----------------------------------------------------------------------------
msg "Getting ready to Extracting Update Files..."
rm -rf $TEMP_EXTRACT_DIR
mkdir -p $TEMP_EXTRACT_DIR
msg "Extracting Update Files..."
tar -xvzf $DOWNLOAD_FILE -C $TEMP_EXTRACT_DIR usr/local
if [ $? -ne 0 ]; then         
	msg_error "Extracting $DOWNLOAD_FILE failed."
	exit 1
fi
msg "Extracting Update Files - Done"
#rm -f $DOWNLOAD_FILE

# -----------------------------------------------------------------------------
# Copy files part 2
# -----------------------------------------------------------------------------

msg "Updating /usr/local/ ... (takes several minutes) ..."
cp -rf $TEMP_EXTRACT_DIR/usr/local/* /usr/local/
if [ $? -ne 0 ]; then         
	msg_error "Updating /usr/local/ ... failed."
	exit 1
fi

# -----------------------------------------------------------------------------
# Uncompress file, part 3
# -----------------------------------------------------------------------------
msg "Getting ready to Extracting Update Files..."
rm -rf $TEMP_EXTRACT_DIR
mkdir -p $TEMP_EXTRACT_DIR
msg "Extracting Update Files..."
tar -xvzf $DOWNLOAD_FILE -C $TEMP_EXTRACT_DIR etc
if [ $? -ne 0 ]; then         
	msg_error "Extracting $DOWNLOAD_FILE failed."
	exit 1
fi
msg "Extracting Update Files - Done"
#rm -f $DOWNLOAD_FILE

# -----------------------------------------------------------------------------
# Copy files part 3
# -----------------------------------------------------------------------------

msg "Updating /etc/ ..."
cp -rf $TEMP_EXTRACT_DIR/etc/* /etc/
if [ $? -ne 0 ]; then         
	msg_error "Updating /etc/ ... failed."
	exit 1
fi

# -----------------------------------------------------------------------------
# Do extra bits and pieces
# -----------------------------------------------------------------------------
msg "Configuring bits and pieces ..."
mv /usr/local/bin/clock /etc/init.d/clock
ln -sfn /etc/init.d/clock /etc/rc3.d/S90clock
ln -sfn /etc/init.d/clock /etc/rc0.d/K10clock
ln -sfn /etc/init.d/clock /etc/rc1.d/K10clock
ln -sfn /etc/init.d/clock /etc/rc2.d/K10clock
ln -sfn /etc/init.d/clock /etc/rc4.d/K10clock
ln -sfn /etc/init.d/clock /etc/rc5.d/K10clock
ln -sfn /etc/init.d/clock /etc/rc6.d/K10clock

mkdir /var/flashlog

# -----------------------------------------------------------------------------
# Install Any New Libraries
# -----------------------------------------------------------------------------
msg "Configuring  Libraries ..."
# ln -sf libusb-0.1.so.0.1.12 /usr/local/lib/libusb-0.1.so.4
# ln -sf libusb-0.1.so.0.1.12 /usr/local/lib/libusb.so

ln -sf libsqlite3.so.3.6.3 /usr/local/lib/libsqlite3.so.1 
ln -sf libsqlite3.so.3.6.3 /usr/local/lib/libsqlite3.so

#ln -sf libsqlite3.so.3.6.3 /usr/local/lib/libpro.so.1 
#ln -sf libsqlite3.so.3.6.3 /usr/local/lib/libpro.so

ln -sf libpro.so.1.0 /usr/local/lib/libpro.so
ln -sf libpro.so.1.0 /usr/local/lib/libpro.so.1

ln -sf libseq.so.1.0 /usr/local/lib/libseq.so
ln -sf libseq.so.1.0 /usr/local/lib/libseq.so.1

ln -sf libfpsu.so.1.0 /usr/local/lib/libfpsu.so
ln -sf libfpsu.so.1.0 /usr/local/lib/libfpsu.so.1

ln -sf libchild.so.1.0 /usr/local/lib/libchild.so
ln -sf libchild.so.1.0 /usr/local/lib/libchild.so.1

# -----------------------------------------------------------------------------
# Creating Backup.txt
# -----------------------------------------------------------------------------
if [ ! -e '/var/local/data/Backup.txt' ]; then
  echo "http://api.cstimeclocks.com/autobackup" > /var/local/data/Backup.txt
fi

# -----------------------------------------------------------------------------
# Modify files
# -----------------------------------------------------------------------------
msg "Modifying Network Files"
sed -i 's|^DHCP_CLIENT="/sbin/udhcpc -i eth0"|DHCP_CLIENT="/sbin/udhcpc -i eth0  -H $(hostname) -s /usr/local/share/udhcpc/default.script"|' /etc/conf.d/net.eth0
chmod 666 /var/local/data/Backup.txt
chmod 666 /var/local/data/SerialNumber.txt
chmod 666 /var/local/data/update_type
chmod 666 /var/local/data/capeclock.db
chmod 666 /var/local/data/alter.sql
# -----------------------------------------------------------------------------
# run any database update scripts
# -----------------------------------------------------------------------------
msg "Updating Database... (You can safely ignore primary key and duplicate column errors) ..."
if [ -s /var/local/data/alter.sql ]; then
	/usr/local/bin/sqlite3shell $DATABASE < /var/local/data/alter.sql
fi	

sed -i 's/^Alias/#Alias/' /etc/httpd/conf/boa.conf
sed -i 's/^ScriptAlias/#ScriptAlias/' /etc/httpd/conf/boa.conf 

# -----------------------------------------------------------------------------
# End
# -----------------------------------------------------------------------------
msg "The End."

# exit 10 (or higher) will tell updateclock this was successful and that we need to reboot the clock
exit 10



