#!/bin/sh
echo "setphptimezone.sh"
CURRENT_DB=/var/local/data/capeclock.db
SQLITE_SHELL=/usr/local/bin/sqlite3shell
#TZ=`echo "select tz_current from thisdev;" | $SQLITE_SHELL $CURRENT_DB`
TZ=`echo "select tz_current from thisdev;" | $SQLITE_SHELL $CURRENT_DB | sed 's_gmt_Etc/GMT_gI'`
echo Setting Time Zone to $TZ

# old clock does not have bash, and these are bashisms
#TZ=${TZ//GMT/Etc/GMT}
#TZ=${TZ//gmt/Etc/GMT}
#TZ=${TZ//Gmt/Etc/GMT}

if [ -e '/etc/php.ini' ]; then
  PHPINI=/etc/php.ini
else
  if [ -e '/etc/php5/cgi/php.ini' ]; then
    PHPINI=/etc/php5/cgi/php.ini
	fi
fi	
echo Editing phpfile $PHPINI, setting timezone to $TZ

TEMPLOG=/var/local/data/temp.log
echo "setphptimezone.sh" > $TEMPLOG
if grep -i -l "\[Date\]" $PHPINI > /dev/null; then
	echo "date.timezone changed to $TZ" >> $TEMPLOG
  if grep -i -l "date.timezone" $PHPINI >> $TEMPLOG; then
		sed -i "s:[;\ ]*date.timezone[0-9a-zA-Z\ \=\/\+\-]*$:date.timezone\ =\ $TZ:"  $PHPINI
	else
	  #! this assumes the [Date] section is last, which it might not be.
	  echo "date.timezone = $TZ" >> $PHPINI
  fi	
else
	echo "[Date] section not found, appending timezone $TZ" >> $TEMPLOG
  echo "[Date]" >> $PHPINI
  echo "date.timezone = $TZ" >> $PHPINI
fi
#cat $PHPINI >> $TEMPLOG
exit 0
